from functools import wraps

from django.shortcuts import redirect
from django.conf import settings


def anonymous_required(redirect_to=None):
    redirect_to = settings.LOGIN_REDIRECT_URL if redirect_to is None else redirect_to

    def decorator(fn):
        @wraps(fn)
        def wrapper(req, *args, **kwargs):
            if not req.user.is_anonymous:
                return redirect(redirect_to)
            return fn(req, *args, **kwargs)
        return wrapper
    return decorator
